/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import java.util.Random;

public class ColorMixer {
    public static Color randomBlend(Random random, Array<Color> colorArray) {
        float[] selectedRatio = new float[colorArray.size];
        float totalAmount = 0.0f;
        for (int cursor = 0; cursor < colorArray.size; ++cursor) {
            float ratio;
            selectedRatio[cursor] = ratio = random.nextFloat();
            totalAmount += ratio;
        }
        Color pickedColor = new Color();
        for (int cursor = 0; cursor < colorArray.size; ++cursor) {
            selectedRatio[cursor] = selectedRatio[cursor] / totalAmount;
            pickedColor.add(colorArray.get(cursor).cpy().mul(selectedRatio[cursor]));
        }
        pickedColor.a = 1.0f;
        return pickedColor;
    }

    public static Color average(Color oldColor, Color newColor) {
        return oldColor.cpy().mul(0.5f).add(newColor.cpy().mul(0.5f));
    }
}

